/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.legacy.image;

import com.andavin.images.legacy.image.LegacyImageSection;
import com.andavin.util.Scheduler;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.entity.ItemFrame;

@SerializableAs(value="com.andavin.images.image.Image")
public final class LegacyImage
implements ConfigurationSerializable {
    public static File dataFolder;
    private final File imageFile;
    private final Location location;
    private final Map<Location, LegacyImageSection> sections;

    public LegacyImage(Location location, File imageFile) {
        this.location = location;
        this.imageFile = imageFile;
        this.sections = new HashMap<Location, LegacyImageSection>();
    }

    public LegacyImage(Map<String, Object> map) {
        this.location = (Location)map.get("location");
        this.sections = new HashMap<Location, LegacyImageSection>((Map)map.get("sections"));
        this.imageFile = new File(dataFolder, (String)map.get("file"));
    }

    public Location getLocation() {
        return this.location.clone();
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public void addSection(short id, int x, int y, Location loc) {
        this.sections.put(loc, new LegacyImageSection(id, x, y));
    }

    public Collection<LegacyImageSection> getSections() {
        return this.sections.values();
    }

    public Map<Location, LegacyImageSection> getImageSections() {
        return this.sections;
    }

    public void destroy() {
        Scheduler.sync(() -> this.sections.forEach((loc, section) -> loc.getWorld().getNearbyEntities(loc, 1.0, 1.0, 1.0).forEach(entity -> {
            Location loc1;
            if (entity instanceof ItemFrame && (loc1 = entity.getLocation()).getBlockX() == loc.getBlockX() && loc1.getBlockY() == loc.getBlockY() && loc1.getBlockZ() == loc.getBlockZ()) {
                entity.remove();
            }
        })));
    }

    public LegacyImageSection getSection(Location loc) {
        LegacyImageSection section = this.sections.get(loc);
        if (section == null) {
            loc.setX((double)loc.getBlockX());
            loc.setY((double)loc.getBlockY());
            loc.setZ((double)loc.getBlockZ());
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
            section = this.sections.get(loc);
        }
        return section;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("location", this.location);
        map.put("sections", this.sections);
        map.put("file", this.imageFile.getName());
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LegacyImage)) {
            return false;
        }
        LegacyImage image = (LegacyImage)o;
        return Objects.equals(this.imageFile, image.imageFile) && Objects.equals(this.location, image.location) && Objects.equals(this.sections, image.sections);
    }

    public int hashCode() {
        return Objects.hash(this.imageFile, this.location, this.sections);
    }
}

